using System;
using System.Collections;
using System.Collections.Generic;
using UnityEngine;


#if ENABLE_VR || ENABLE_AR
using UnityEngine.XR;
using UnityEngine.SpatialTracking;

namespace UnityEngine.Experimental.XR.Interaction
{
    /// <summary>
    /// The BasePoseProvider type is used as the base interface for all "Pose Providers"
    /// Implementing this abstract class will allow the Pose Provider to be linked to a Tracked Pose Driver.
    /// </summary>
    [Serializable]
    public abstract class BasePoseProvider : MonoBehaviour
    {
        /// <summary> Gets the Pose value from the Pose Provider. returns NoData as this is a default implementation. Specializations will return the correct bitflags relating to the Pose data they are returning</summary>
        public virtual PoseDataFlags GetPoseFromProvider(out Pose output)
        {          
            // disabling the obsolete warning/error here so that no error is generated by the use of this function.
#pragma warning disable 618,619
            if(TryGetPoseFromProvider(out output))
            {
                return PoseDataFlags.Position | PoseDataFlags.Rotation;
            }
#pragma warning restore 618,619
            return PoseDataFlags.NoData;
        }

        /// <summary>
        /// This function is provided for backwards compatibiltiy with the BasePoseProvider found in com.untiy.xr.legacyinputhelpers v1.3.X
        /// Please do not implement this function, instead use the new API via GetPoseFromProvider
        /// </summary>
        [System.Obsolete("This function is provided for backwards compatibiltiy with the BasePoseProvider found in com.untiy.xr.legacyinputhelpers v1.3.X Please do not implement this function, instead use the new API via GetPoseFromProvider",false)]
        public virtual bool TryGetPoseFromProvider(out Pose output)
        {
            output = Pose.identity;
            return false;
        }
    }
}

#endif
